/*
 *  LICENSE:
 *  Copyright (c) 2008 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 *  
 *
 *  File: $Id: fir.h,v 1.4 2008/08/01 20:57:20 b17778 Exp $
 *
 */

/*
 * The input of the FIR is of __accum type
 */
typedef __accum* __aacFirInput;

/*
 * The output of the FIR is of __accum type
 */
typedef __accum* __aacFirOutput; 

/*
 * The state of the FIR consits of a number of stages,
 * an offset for the circular buffer, and the state arrary
 */
typedef struct
{
	AXEInt32 iFilterStages;
	AXEInt32 iCircBufOffset;
	__accum* aacZ;
} __sFirState;

/*
 * The parameters of the FIR filter consits of a field of coefficients
 * and integer indicating how many coefficients exist
 */ 
typedef struct
{
	AXEInt32 iCoefCount;
	__fixed* afiCoef;
} __sFirParams;
